/* redefines parseJSON to make sure that the JSON is output to the console log - uncomment this for easy debugging */
/*var originalParseJSON = jQuery.parseJSON;
$.extend({
	parseJSON: function( data ) {
		console.log(data);
		return originalParseJSON(data);
	}
});*/

			var draft_interval;
			$().ready(function() {
				if($('input#attach').length) {
					$('input#attach').css({'top':$('tr#attach_row').position().top, 'left':$('tr#attach_row').position().left+50});
				}
				 $('.my_modal_open').click(function(){
				        $('#my_modal').popup({
				            'autoopen': true
				        });
				    });
				 
				$.ajaxSetup({
					cache: false
				});
				$(':button').keyup(function(e) {
					var code = (e.keyCode ? e.keyCode : e.which);
					if(code == 13) { //Enter keycode
						e.preventDefault();
						e.stopPropagation();
						if($(e.target).is(":focus")) {
							$(e.target).trigger('click');
						}
					}
				});
				$(':button').keypress(function(e) {
					var code = (e.keyCode ? e.keyCode : e.which);
					if(code == 13) { //Enter keycode
						e.preventDefault();
						e.stopPropagation();
					}
				});
				
				if($('#messages').length) { 
					//check for new messages
					setInterval(function() {
						ajaxMessageCheck();
					},30000);
				}
				if($('#compose_form').length) { 
					draft_interval = setInterval(function() {
						autoSaveDraft();
					},60000);
				}
				if($('#dropzone').length) {
					var token_obj = {};
					token_obj[$('input[type="hidden"].token').attr('id')] = $('input[type="hidden"].token').val();
					$('#dropzone').filedrop({
						url: '/inbox/attach',              // upload handler, handles each file separately
						paramname: 'attach',          // POST parameter name used on serverside to reference file
						data: token_obj,
						headers: {'X-Requested-With' : 'XMLHttpRequest' },
						error: function(err, file) {
							switch(err) {
								case 'BrowserNotSupported':
									alert('This browser does not support drag and drop file upload. Upload files normally instead by clicking "Attach a file..." link');
									break;
								case 'TooManyFiles':
									// user uploaded more than 'maxfiles'
									break;
								case 'FileTooLarge':
									alert('File is too large. Total attachment size is limited to 10 MB.');
									break;
								default:
									break;
							}
						},
						maxfiles: 25,
						maxfilesize: 10,    // max file size in MBs
						dragOver: function() {
							$('#dropzone').css('border','solid black 1px');
							$('#dropzone').css('background','#6f6');
							var token = $('input[type="hidden"].token').val();
							this.data[$('input[type="hidden"].token').attr('id')] = token;
						},
						dragLeave: function() {
							$('#dropzone').css('border','dashed black 1px');
							$('#dropzone').css('background','#fff');
						},
						docOver: function() {
							$('#dropzone').css('display','block');
						},
						docLeave: function() {
							$('#dropzone').css('display','none');
						},
						drop: function() {
							$('#dropzone').css('display','none');
						},
						uploadStarted: function(i, file, len){
							$('<tr><td><img src="/images/paperclip.png" alt="Attachment" \/></td><td><span id="filename' + i + '" style="display: block; overflow: hidden; text-overflow: ellipsis; float: left;"><img style="margin-right: 5px;" src="/images/ajax-loader.gif" alt="Uploading..." />' + file.name + '</span></td></tr>').insertAfter($('#dropzone').parent().parent());
							$('input#attach').css({'top':$('tr#attach_row').position().top, 'left':$('tr#attach_row').position().left+50});
						},
						uploadFinished: function(i, file, response, time) {
							if(file.name.indexOf('.xml') == file.name.length - 4) {
								$.ajax({
									url : '/inbox/ajax_xml_check/'+ rawurlencode(response['filename']) + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
									success: function(data,statusText,xhr) {
										if(data.indexOf('<!-- AUTH -->') >=0) {
												window.location = '/auth/logout';
										}
										else {
											if($('#filename' + i).html().indexOf(data) < 0) { 
												data = data.replace(/[\r\n]+$/, '');
												$('#filename' + i).html($('#filename' + i).html() + ' (' + data + ')');
											}
										}
									}
								});
							}
							$('#progress' + i).remove(); 
							var bytes = response['filesize'];
							var filesize = (bytes / 1024); var suffix = ' KB';
							if(filesize > 1000) { filesize = (filesize / 1024); var suffix = ' MB'; }
							if(filesize > 1000) { filesize = (filesize / 1024); var suffix = ' GB'; }
							$('#attachment_size').val(parseInt($('#attachment_size').val()) + bytes);
							$('<span style="margin-right: 5px; display: block; float: left;">' + Math.round(filesize*10)/10 + suffix + '</span><a class="delete" href="#" onclick="$.ajax({ url: \'/inbox/clear_attachment/' + rawurlencode(response['filename']) + '/\' + \'?\'+$(\'input[type=&quot;hidden&quot;].token\').attr(\'id\')+\'=\'+$(\'input[type=&quot;hidden&quot;].token\').val()}); $(\'#attachment_size\').val(parseInt($(\'#attachment_size\').val()) - ' + bytes + '); $(this).parent().parent().remove(); $(\'input#attach\').css({\'top\':$(\'tr#attach_row\').position().top, \'left\':$(\'tr#attach_row\').position().left+50});">Remove</a>').insertAfter('#filename' + i);
							$('#filename' + i).html('<a class="preview" target="_blank" href="/inbox/preview_attachment/'+rawurlencode(response['filename'])+'" title="'+file.name+'">'+file.name + '</a>');
							
							var token = response['token'];
							$('input[type="hidden"].token').val(token);
							this.data[$('input[type="hidden"].token').attr('id')] = token;
						},
						progressUpdated: function(i, file, progress) {
							// this function is used for large files and updates intermittently
							// progress is the integer value of file being uploaded percentage to completion
							$('#progress' + i).remove();
							if(progress < 100) { $('<div id="progress'+ i + '" style="width: 200px; height: 10px; border: solid black 1px;"><div style="background: blue; width: ' + progress + '%; height: 100%; "></div></div>').insertAfter('#filename' + i); }
						},
						speedUpdated: function(i, file, speed) {
							// speed in kb/s
						},
						rename: function(name) {
						// name in string format
						// must return alternate name as string
						},
						beforeEach: function(file) {
							// file is a file object
							// return false to cancel upload
						},
						afterAll: function() {
							// runs after all files have been uploaded or otherwise dealt with
						}
					});
				}
				if($("#message_body").length) { 
					new TINY.editor.edit('editor',{
						id:'message_body',
						title:'Message Body Rich Text Editor',
						width: $("#message_body").css('width'),
						height: $("#message_body").css('height'),
						cssclass:'te',
						controlclass:'tecontrol',
						rowclass:'teheader',
						dividerclass:'tedivider',
						controls:['toggle','|','bold','italic','underline','strikethrough','|','subscript','superscript','|',
								  'orderedlist','unorderedlist','|','outdent','indent','|','leftalign',
								  'centeralign','rightalign','blockjustify','|','unformat','|','undo','redo','n',
								  'font','size','style','|','image','hr','link','unlink','|','cut','copy','paste','print'],
						footer:true,
						fonts:['Verdana','Arial','Georgia','Trebuchet MS'],
						xhtml:true,
						cssfile:'/css/tinyeditor.css',
						bodyid:'editor',
						footerclass:'tefooter',
						toggle:{text:'source',activetext:'wysiwyg',cssclass:'toggle'},
						resize:{cssclass:'resize'}
					});
					$('textarea[name="message_body"]').val('');
				}
				$(window).scroll(function() { 
					if($(window).scrollTop() != 0) {
						$("#header.inbox").css("-webkit-box-shadow","0px 4px 5px -2px #999");
						$("#header.inbox").css("-moz-box-shadow","0px 4px 5px -2px #999");
						$("#header.inbox").css("box-shadow","0px 4px 5px -2px #999");
					}
					else { 
						$("#header.inbox").css("-webkit-box-shadow","0px 0px 0px 0px #999");
						$("#header.inbox").css("-moz-box-shadow","0px 0px 0px 0px #999");
						$("#header.inbox").css("box-shadow","0px 0px 0px 0px #999");
					}
					$(".menu_modal").remove();
					if($('.suggest').length) { $('.suggest').css("top",($('textarea[name="message_to"]').offset().top + 20) + "px"); }
				});
				if($('a.lightbox').length) { 
					function formatTitle(title, currentArray, currentIndex, currentOpt) {
						var type = title.split('.').pop();
						if(type && type.length) {
							if(type.toLowerCase() == 'jpeg' || type.toLowerCase() == 'jpg' || type.toLowerCase() == 'gif' || type.toLowerCase() == 'png') {
								$('#fancybox-wrap').draggable();
								var id = $('input[name="msg_id"]');
								if(id && id.length) {
									return '<table id="fancybox-title-float-wrap" cellpadding="0" cellspacing="0"><tbody><tr><td id="fancybox-title-float-left"></td><td id="fancybox-title-float-main"><a class="title_link" href="/inbox/get_attachment/' + id.val() + '/' + rawurlencode(title) + '/download/?' + $('input[type="hidden"].token').attr('id') + '=' + $('input[type="hidden"].token').val() + '">Download Image as File</a></td><td id="fancybox-title-float-right"></td></tr></tbody></table>';
								}
							}
							else if(type.toLowerCase() == 'xml') {
								var id = $('input[name="msg_id"]');
								if(id && id.length) {
									return '<table id="fancybox-title-float-wrap" cellpadding="0" cellspacing="0"><tbody><tr><td id="fancybox-title-float-left"></td><td id="fancybox-title-float-main"><a class="title_link" href="/inbox/get_attachment/' + id.val() + '/' + title + '/download/pdf/?' + $('input[type="hidden"].token').attr('id') + '=' + $('input[type="hidden"].token').val() + '">Download to PDF</a></td><td id="fancybox-title-float-right"></td></tr></tbody></table>';
								}
							}
							else { return title; }
						}
						else { return title; }
					}
					$('a.lightbox').fancybox({'titleFormat' : formatTitle }); 
				}
				if($('span.menu').length) {
					$('span.menu').click(
						function(e) {
							$('.menu_modal').remove();
							var mailbox = $('[id="' + e.target.id + '"]').parent().children('#custom_folder_name').text();
							mailbox = base64_encode(mailbox);
							$(document.body).append(
								"<div style=\" top:" + e.pageY + "px; " + "left: " + (e.pageX + 10) + "px;" + "\" class=\"menu_modal\">" +
									"<ul>" + 
										'<li><a onclick="' +
										'var token_obj = {};' +
										'token_obj[$(\'input[type=&quot;hidden&quot;].token\').attr(\'id\')] = $(\'input[type=&quot;hidden&quot;].token\').val();' +
										'$(\'[id=&quot;' + e.target.id + '&quot;]\').parent().children(\'#custom_folder_name\').css(\'display\',\'inline\');' +
										'$(\'[id=&quot;' + e.target.id + '&quot;]\').parent().children(\'a\').css(\'display\',\'none\');' + 
										'$(\'[id=&quot;' + e.target.id + '&quot;]\').parent().children(\'#custom_folder_name\').editable(\'/inbox/rename_folder/' +
										rawurlencode(mailbox) + '/\',' + 
										'{ ' + 
											'event : \'rename_event\',' +
											'height: 12,' +
											'width: 100,' +
											'submitdata: token_obj,' +
											'style : \'position: relative; float: right; z-index: 100;\',' +
											'onblur : \'submit\',' +
											'indicator : \'Saving...\',' +
											'callback: function(value, settings) ' +
													  '{ ' + 
															'$(this).unbind(settings.event);' +
													  '}' +
										'});' +
										'$(\'[id=&quot;' + e.target.id + '&quot;]\').parent().children(\'#custom_folder_name\').trigger(\'rename_event\');">Rename</a></li>' + 
										'<li><a href="/inbox/archive_folder/' + rawurlencode(mailbox) + '/">Archive</a></li>' + 
									'</ul>'  +
								'</div>'
							);
							$('html').click(function(e) { $('.menu_modal').remove(); });
							e.stopPropagation();
						}
					);
				}
				//event handlers
				var delay = (function(){
					var timer = 0;
					return function(callback, ms){
						clearTimeout (timer);
						timer = setTimeout(callback, ms);
					};
				})();

				//token input event handlers
				if($('textarea[name="message_to"]').length) {
					var message_to_text = $('textarea[name="message_to"]').text();
					var message_cc_text = $('textarea[name="message_cc"]').text();
					$('textarea[name="message_to"], textarea[name="message_cc"]').ready(function(){
						$("#message_to").tokenInput("/inbox/get_contacts_search/",
						{
							theme: "dpii",
							searchDelay: 500,
							hintText: "Enter a direct address",
							tokenDelimiter: ";",
							onAdd: function(e) { 
								if(!multipleAddressSplit(e)) { 
									verifyAddress(e); 
								}
							},
							noResultsText: "This is not a trusted address",
							resultsFormatter: function(item){ 
								if(item.description == null) {
									return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.id + "</div></div></li>" 
								}
								else {
									return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.description + "</div></div></li>" 
								}
							},
							tokenFormatter: function(item) { item.uid = uniqid(); 
								if(item.description == null) {
									return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>" 
								}
								else{
									return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" onclick=\"viewDistList('" + item.uid + "','" + htmlentities(base64_encode(json_encode(item))) + "','message_to');\" title=\"" + item.description +"\" data-address=\""+item.id+"\"><img src=\"/images/group.png\" class=\"hover_pointer\" alt=\"Distribution List\"> " + item.name + "</p></li>";
								}
							}
						});

						$("#message_cc").tokenInput("/inbox/get_contacts_search/",
								{
									theme: "dpii",
									searchDelay: 500,
									hintText: "Enter a direct address",
									tokenDelimiter: ";",
									onAdd: function(e) { 
										if(!multipleAddressSplit(e)) { 
											verifyAddress(e); 
										}
									},
									noResultsText: "This is not a trusted address",
									resultsFormatter: function(item){ 
										if(item.description == null) {
											return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.id + "</div></div></li>" 
										}
										else {
											return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.description + "</div></div></li>" 
										}
									},
									tokenFormatter: function(item) { item.uid = uniqid(); 
										if(item.description == null) {
											return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>" 
										}
										else{
											return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" onclick=\"viewDistList('" + item.uid + "','" + htmlentities(base64_encode(json_encode(item))) + "','message_cc');\" title=\"" + item.description +"\" data-address=\""+item.id+"\"><img src=\"/images/group.png\" class=\"hover_pointer\" alt=\"Distribution List\"> " + item.name + "</p></li>";
										}
									}
								});
						
						if(message_to_text.length) {
							var data_array = html_entity_decode(message_to_text).split(';');
							for(var i = 0; i < data_array.length; i++) {
								if($.trim(data_array[i]).length) {
									var address = $.trim(data_array[i]);
									var extracted = address.match(/([a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+\.[a-zA-Z0-9._-]+)/gi);
									$('textarea[name="message_to"]').tokenInput('add',{ name : htmlentities(address,'ENT_NOQUOTES'), id : htmlentities(extracted), uid: uniqid() });
								}
							}
							
						}
						if(message_cc_text.length) {
							var data_array = html_entity_decode(message_cc_text).split(';');
							for(var i = 0; i < data_array.length; i++) {
								if($.trim(data_array[i]).length) {
									var address = $.trim(data_array[i]);
									var extracted = address.match(/([a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+\.[a-zA-Z0-9._-]+)/gi);
									$('textarea[name="message_cc"]').tokenInput('add',{ name : htmlentities(address,'ENT_NOQUOTES'), id : htmlentities(extracted), uid: uniqid() });
								}
							}
							
						}						
					});
				}
				$('#main_form').keypress(function(e) {
					var code = (e.keyCode ? e.keyCode : e.which);
					if(code == 13) {
						if($("#main_form").length) {
							if(!$('#message_body').is(":focus")){
								var tag = $(e.target).prop('tagName');
								if(tag == 'INPUT' || tag == 'SELECT') {
									var name = $(e.target).attr('name');
									var id = $(e.target).attr('id');
									if(name == 'message_to' || name == 'message_cc' || name == 'message_to' || name == 'search_input' || name == 'message_subject' || name == 'priority' || name == 'folder_name' || id == 'tefont' || id == 'tesize' || id == 'testyle'  || id == 'move_select' || id == 'token-input-message_to' || id == 'token-input-message_cc' || $(e.target).hasClass('selectmsg')) {
										e.preventDefault();
										if(name == 'search_input') { 
											$('#send_btn').attr('clicked','true'); 
											$('#search_btn').click(); 
										}
									}
								}
							}
						}
						if(e.target.id == "message_to" || e.target.id == "message_cc") {
							if($('.suggest').length) {
								e.preventDefault();
								var preserve = $('textarea:focus').val().substring(0,$('textarea:focus').val().lastIndexOf(';') + 1);
								var suggestions = $('.suggest > ul > li');
								var suggestion = suggestions[0];
								var suggestion = $(suggestion).text();
								$('textarea:focus').val(preserve.replace(/[\r\n]+$/, '') + suggestion.replace(/[\r\n]+$/, '') + ';');
								$('.suggest').remove();
							}
							return false;
						}
					}
				});
				$('#save_btn').click(function(e) { $('#save_btn').attr('clicked','true'); });
				$('#main_form').submit(function(e) { 
					if($('#send_btn').attr('clicked') === 'clicked') {
						e.preventDefault();
						mainFormValidationOnSubmit();
					}
					else {
						$('#send_btn').attr('clicked','clicked'); 
						return mainFormValidationOnSubmit(); 
					}
				});
				$('#main_form').bind('autosave',function(e){
					e.preventDefault();
					
					if($('#message_body').css('display') == 'none') {
						$('textarea[name="message_body"]').val(editor.getEditorContent());
					}					
					
					dataString = $("#main_form").serialize();
					$.ajax({
						type: "POST",
						url: "/inbox/ajax_draft_save/",
						data: dataString,
						dataType: "html",
						success: function(data) {
							$('.autosave').remove();
							var data_arr = $.parseJSON(data);	
							var token = data_arr['token'];
							var id = data_arr['id'];
							$('input[type="hidden"].token').val(token);
							$('input[name="msg_id"]').val(id);
						},
						error: function(data) { 
							$('.autosave').remove();
							var data_arr = $.parseJSON(data);	
							var token = data_arr['token'];
							$('input[type="hidden"].token').val(token);
						}
					});
				});
				if($('.admin_chart').length) {
					$('a.chart').bind('click',function(event){
						event.preventDefault();
						$.ajax({
							url : event.target.href + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
							success: function(data) {
								if(data.indexOf('<!-- AUTH -->') >=0) {
									window.location = '/auth/logout';
								}
								else {
									$('.admin_chart').html(data);
									$('a.chart').parent().removeClass('active-tab');
									$(event.target).parent().addClass('active-tab');
								}
							}
						});
					});
					if($('.admin_chart').html().length == 0) {
						$.ajax({
								url : $('.active-tab > a').attr('href') + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
								success: function(data) {
									if(data.indexOf('<!-- AUTH -->') >=0) {
										window.location = '/auth/logout';
									}
									else {
										$('.admin_chart').html(data);
									}
								}
						});
					}
				}
				if($('.address-book').length) {
					var modal_message_to_text = $('textarea[name="modal_message_to"]').text();
					var modal_message_cc_text = $('textarea[name="modal_message_cc"]').text();
					
					$('.address-book').click(function(e) {
						$.fancybox.showActivity();
						$.ajax({
							url : '/addressbook/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
						}).done(function(data){
							if(data.indexOf('<!-- AUTH -->') >=0) {
								window.location = '/auth/logout';
							}
							else {
								$.fancybox({
									'content' : data,
									'autoDimensions' : false,
									'padding' : 0,
									'height' : 500,
									'width' : 750,
									'titlePosition' : 'inside',
									'titleFormat' : function() { 
										return '<div id="footer"><div id="address_list">' + 
												'<table><tr><td><button onclick="addModalTo()">To &#8594;</button></td>' + 
												'<td><label for="modal_message_to" style="display:none;">To</label>' + 
												'<td><label for="token-input-modal_message_to" style="display:none;">To</label>' + 
												'<textarea name="modal_message_to" id="modal_message_to"></textarea></td></tr>' +												
												'<tr><td><button onclick="addModalCC()">CC &#8594;</button></td>' + 
												'<td><label for="modal_message_cc" style="display:none;">CC</label>' + 
												'<td><label for="token-input-modal_message_cc" style="display:none;">CC</label>' + 
												'<textarea name="modal_message_cc" id="modal_message_cc"></textarea></td></tr>' + 
												'</table>' + 
												'<div style="float: right; padding: 5px;">' + 
												'<button type="button" onclick="useAddressList();">OK</button>' + 
												'<button type="button" onclick="cancelAddressList()" id="cancel_button">Cancel</button></div></div></div>'; 
									},
									'onComplete' : function() { 
										$('#address_search_input').focus();
										$('#address_search_input').focus(); 
										$("#modal_message_to").tokenInput('/inbox/get_contacts_search/',
										{
											theme: "dpii",
											searchDelay: 500,
											hintText: "Enter a direct address",
											tokenDelimiter: ";",
											onAdd: function(e) { 
												if(!multipleAddressSplit(e)) { 
													verifyAddress(e); 
												}
											},
											noResultsText: "This is not a trusted address",
											resultsFormatter: function(item){ 
												if(item.description == null) {
													return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.id + "</div></div></li>" 
												}
												else {
													return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.description + "</div></div></li>" 
												}
											},
											tokenFormatter: function(item) { item.uid = uniqid(); 
												if(item.description == null) {
													return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>" 
												}
												else{
													return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" onclick=\"viewDistList('" + item.uid + "','" + htmlentities(base64_encode(json_encode(item))) + "','modal_message_to');\" title=\"" + item.description + "\" data-address=\""+item.id+"\"><img src=\"/images/group.png\" class=\"hover_pointer\" alt=\"Distribution List\"> " + item.name + "</p></li>" 
												}
											}
										});
										
										$("#modal_message_cc").tokenInput('/inbox/get_contacts_search/',
												{
													theme: "dpii",
													searchDelay: 500,
													hintText: "Enter a direct address",
													tokenDelimiter: ";",
													onAdd: function(e) {
														if(!multipleAddressSplit(e)) { 
															verifyAddress(e); 
														}
													},
													noResultsText: "This is not a trusted address",
													resultsFormatter: function(item){ 
														if(item.description == null) {
															return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.id + "</div></div></li>" 
														}
														else {
															return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.description + "</div></div></li>" 
														}
													},
													tokenFormatter: function(item) { item.uid = uniqid(); 
														if(item.description == null) {
															return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>" 
														}
														else{
															return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" onclick=\"viewDistList('" + item.uid + "','" + htmlentities(base64_encode(json_encode(item))) + "','modal_message_cc');\" title=\"" + item.description + "\" data-address=\""+item.id+"\"><img src=\"/images/group.png\" class=\"hover_pointer\" alt=\"Distribution List\"> " + item.name + "</p></li>" 
														}
													}
												});
									}
								});
								
								$('#fancybox-wrap').css("top","0px");
								$('#fancybox-outer').css({ "border" : "solid #efefef 10px", "border-radius" : "10px"});
								$('#fancybox-close').css({"top": "-25px", "right" : "-25px"});
								
								$("#address_book_wrapper").parent().scroll(function(){			
									$("#result_panel")
										.stop()
										.animate({"marginTop": ($("#address_book_wrapper").parent().scrollTop()) + "px"}, 400);			
								});
							}
						});
						e.preventDefault();
					});
				}
				if($('.contact-list').length) {
					$('.contact-list').click(function(e) {
						$.fancybox.showActivity();
						$.ajax({
							url : '/addressbook/contacts/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
						}).done(function(data){
							if(data.indexOf('<!-- AUTH -->') >=0) {
								window.location = '/auth/logout';
							}
							else {
								$.fancybox({
									'content' : data,
									'padding' : 0,
									'autoDimensions' : false,
									'height' : 500,
									'width' : 750,
									'titlePosition' : 'inside',
									'titleFormat' : function() { 
										return '<div id="footer"><div id="address_list">' + 
												'<table><tr><td><button onclick="addModalTo()">To &#8594;</button></td>' +
												'<td><label for="modal_message_to" style="display:none;">To</label>' + 
												'<td><label for="token-input-modal_message_to" style="display:none;">To</label>' + 
												'<textarea name="modal_message_to" id="modal_message_to"></textarea></td></tr>' + 
												'<tr><td><button onclick="addModalCC()">CC &#8594;</button></td>' + 
												'<td><label for="modal_message_cc" style="display:none;">CC</label>' + 
												'<td><label for="token-input-modal_message_cc" style="display:none;">CC</label>' + 
												'<textarea name="modal_message_cc" id="modal_message_cc"></textarea></td></tr>' + 
												'</table>' + 
												'<div style="float: right; padding: 5px;">' + 
												'<button type="button" onclick="useAddressList();">OK</button>' +
												'<button type="button" onclick="cancelAddressList()" id="cancel_button">Cancel</button></div></div></div>'; 
									},
									'onComplete' : function() { 
										$('#add_contact_link').focus();
										$('#add_contact_link').focus();
										$("#modal_message_to").tokenInput('/inbox/get_contacts_search/',
											{
												theme: "dpii",
												searchDelay: 500,
												hintText: "Enter a direct address",
												tokenDelimiter: ";",
												onAdd: function(e) {
													if(!multipleAddressSplit(e)) { 
														verifyAddress(e); 
													}
												},
												noResultsText: "This is not a trusted address",
												resultsFormatter: function(item){ 
													if(item.description == null) {
														return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.id + "</div></div></li>" 
													}
													else {
														return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.description + "</div></div></li>" 
													}
												},
												tokenFormatter: function(item) { item.uid = uniqid(); 
													if(item.description == null) {
														return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>" 
													}
													else{
														return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" onclick=\"viewDistList('" + item.uid + "','" + htmlentities(base64_encode(json_encode(item))) + "','modal_message_to');\" title=\"" + item.description + "\" data-address=\""+item.id+"\"><img src=\"/images/group.png\" class=\"hover_pointer\" alt=\"Distribution List\"> " + item.name + "</p></li>" 
													}
												}
										});
										$("#modal_message_cc").tokenInput('/inbox/get_contacts_search/',
												{
													theme: "dpii",
													searchDelay: 500,
													hintText: "Enter a direct address",
													tokenDelimiter: ";",
													onAdd: function(e) {
														if(!multipleAddressSplit(e)) { 
															verifyAddress(e); 
														}
													},
													noResultsText: "This is not a trusted address",
													resultsFormatter: function(item){ 
														if(item.description == null) {
															return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.id + "</div></div></li>" 
														}
														else {
															return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.description + "</div></div></li>" 
														}
													},
													tokenFormatter: function(item) { item.uid = uniqid(); 
														if(item.description == null) {
															return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>" 
														}
														else{
															return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" onclick=\"viewDistList('" + item.uid + "','" + htmlentities(base64_encode(json_encode(item))) + "','modal_message_cc');\" title=\"" + item.description + "\" data-address=\""+item.id+"\"><img src=\"/images/group.png\" class=\"hover_pointer\" alt=\"Distribution List\"> " + item.name + "</p></li>" 
														}
													}
											});
									}
								});
								$('#fancybox-wrap').css("top","0px");
								$('#fancybox-outer').css({ "border" : "solid #efefef 10px", "border-radius" : "10px"});
								$('#fancybox-close').css({"top": "-25px", "right" : "-25px"});
	
								$("#address_book_wrapper").parent().scroll(function(){			
									$("#result_panel")
										.stop()
										.animate({"marginTop": ($("#address_book_wrapper").parent().scrollTop()) + "px"}, 400);			
								});
							}
						});
						e.preventDefault();
					});
				}
				if($('.theme_preview').length) {
					$('.theme_preview').click(function(e) {
						var id = $(e.target).attr('id').replace('theme','');
						$('input[name="theme_id"]').val(id);
						$('#theme_form').submit();
					});
				}
				
				if($('span.mailbox_select').length) {
					$('span.mailbox_select').click(function(e) {
						var show = false;
						if($('div.mailbox_select').attr('style') == null) { show = true; }
						else {
							if($('div.mailbox_select').attr('style').indexOf('display: none') !== -1) { show = true; }
						}
						if(show) {
							$('div.mailbox_select').attr('style','display: block;');
						}
						else {
							$('div.mailbox_select').attr('style','display: none;');
						}
						$('html').click(function(event) { $('div.mailbox_select').attr('style','display: none;'); });
						e.stopPropagation();
					});
					$('span.mailbox_select > a').click(function(e) {
						var show = false;
						if($('div.mailbox_select').attr('style') == null) { show = true; }
						else {
							if($('div.mailbox_select').attr('style').indexOf('display: none') !== -1) { show = true; }
						}
						if(show) {
							$('div.mailbox_select').attr('style','display: block;');
							$('div.mailbox_select > ul > li > a:first').focus();
						}
						else {
							$('div.mailbox_select').attr('style','display: none;');
						}
						$('html').click(function(event) { $('div.mailbox_select').attr('style','display: none;'); });
						e.stopPropagation();
					});
				}
				
				//attachment handling
				if($('#attachment_form').length) {
					//register link focus event
					$('a.attach_link').focus(function(e) { $('input#attach').focus(); });
					//register focus event
					$('input#attach').focus(function(e) {
						$('a.attach_link').css('border','solid black 2px');
					});
					//register blur event
					$('input#attach').blur(function(e) {
						$('a.attach_link').css('border','0');
					});
					//register keydown event to do correct tab order
					$('input#attach').keydown(function(e) {
						var code = (e.keyCode ? e.keyCode : e.which);
						if(code == 9) { //tab keycode
							e.preventDefault();
							if(e.shiftKey) { $('#priority').focus(); }
							else { 
								if($('#tinyeditorframe').css('display') === "none"){
									$('#message_body').focus();
								}
								else{
									$('#tinyeditorframe').contents().find('html').focus(); //this works in Firefox
									$('#tinyeditorframe').contents().find('body').focus(); //if previous line does not focus, then this will 
								}
							}
						}
					});
					
					var path = '';
					var fileNameIndex = 0;
					var filename = '';
					
					var options = {
						beforeSend: function(xhr) {
							
							var attach_count = $("#attach_count").val();
							var attach_id = 'attach'+$("#attach_count").val();
							$("#attach_count").val(parseInt(attach_count) + 1);
							xhr.attach_count = attach_count;
							xhr.attach_id = attach_id;
							xhr.filename = filename;
						},
						beforeSubmit: function() {
							
							var attach_id = 'attach'+$("#attach_count").val();
							path = $('#attach').val();
							fileNameIndex = path.lastIndexOf("\\") + 1;
							if(fileNameIndex > 1) {
								filename = path.substr(fileNameIndex);
							}
							else {
								var fileNameIndex = path.lastIndexOf("/") + 1;
								if(fileNameIndex > 1) {
									filename = path.substr(fileNameIndex);
								}
								else { filename = path; }
							}
							var table = $('#compose_form');
							var refnode = $('#attach_row');
							var attach = $('<tr class="attach_input" style="white-space: nowrap" id="' + attach_id + '"\><td><img src="/images/paperclip.png" alt="Attachment Icon" /></td><td colspan="2" style="display: block; width: 350px; overflow: hidden; text-overflow: ellipsis; float: left;"><img style="margin-right: 5px;" src="/images/ajax-loader.gif" alt="Uploading..." />Uploading '+filename+'...</td></tr>');
							attach.insertAfter(refnode);
							refnode.remove();
							$("<tr id=\"attach_row\"><td><img src=\"/images/paperclip.png\" alt=\"Attachments\" /></td><td><a href=\"javascript:addAttach();\" class=\"attach_link\">Attach another file</a></td></tr>").insertAfter(attach);
							$('input#attach').css({'top':$('tr#attach_row').position().top, 'left':$('tr#attach_row').position().left+50});
							$('a.attach_link').focus(function(e) { $('input#attach').focus(); });
						},
						dataType: 'text',
						success: function(data,status,xhr) {
							if(xhr.status > 0) {
								if(data.length > 0) {
									var table = $('#compose_form');
									var refnode = $('#attach_row');
									if(table != null && refnode != null) {
										var data_arr = $.parseJSON(data);
										var token = data_arr['token'];
										$('input[type="hidden"].token').val(token);
										
										var bytes = data_arr['filesize'];
										var filesize = (bytes / 1024); var suffix = ' KB';
										if(filesize > 1000) { filesize = (filesize / 1024); var suffix = ' MB'; }
										if(filesize > 1000) { filesize = (filesize / 1024); var suffix = ' GB'; }
										$('tr#'+xhr.attach_id).html('<td><img src="/images/paperclip.png" alt="Attachment Icon" /></td><td colspan="2" style="width: 500px; display: block; white-space: nowrap; float: left;"><a class="preview" target="_blank" href="/inbox/preview_attachment/'+rawurlencode(data_arr['filename'])+'" title="'+xhr.filename+'">'+xhr.filename + '</a><span style="margin-right: 5px; display: block; float: left;">' + Math.round(filesize*10)/10 + suffix + '</span><a class="delete" href="#" onclick="$.ajax({ url: \'/inbox/clear_attachment/' + rawurlencode(data_arr['filename']) + '/\' + \'?\'+$(\'input[type=hidden].token\').attr(\'id\')+\'=\'+$(\'input[type=hidden].token\').val()}); $(\'#attachment_size\').val(parseInt($(\'#attachment_size\').val()) - ' + bytes + '); $(this).parent().parent().remove(); deleteAttach();">Remove</a></td>');
										$('tr#'+xhr.attach_id+' > td > a').focus();
										$('#attachment_size').val(parseInt($('#attachment_size').val()) + bytes);
									}
								}
								$('#attach').replaceWith($('#attach').val(null).clone(true));
							}
							else {
								var data_arr = $.parseJSON(data);
								var token = data_arr['token'];
								$('input[type="hidden"].token').val(token);
								
								$('#'+xhr.attach_id).remove();
								deleteAttach(xhr.attach_id);
								alert('Unexpected error encountered while uploading.  Please check that the file is a valid type and that the total size of your attachments does not exceed 10 MB.');
							}
						},
						error: function(xhr) {
							$('#'+xhr.attach_id).remove();
							deleteAttach(xhr.attach_id);
							if(xhr.status == 413) {
								alert('Error encountered while uploading file.  Adding this file would exceed the 10MB size limit for attachments.');
							}
							else { 
								alert('Unexpected error encountered while uploading file.  Please check that the file is a valid type and that the total size of your attachments does not exceed 10 MB.'); 
							}						
						}
					}; 
					
					$('#attachment_form').ajaxForm(options);
					
					//register onchange event
					$('input#attach').change(function(e) {
						//performing this if check because IE11 fires this ajaxform submission twice somehow.
						//the extra one has null value for the file path
						if($('#attach').val()){
							$('#attachment_form').ajaxForm(options).submit();
							$('#attach').val(null);
							e.stopPropagation();
						}
					});
				}
				
				//Accessibility Related Events
				var is_webkit = navigator.userAgent.toLowerCase().indexOf('webkit') > -1;
				var is_opera = navigator.userAgent.toLowerCase().indexOf('opera') > -1;
				if(is_webkit || is_opera)
				{
					var target = document.getElementById('menuContent');
					if(target != null) {
						target.href="#menuContent";
						target.innerText="Menu";
						var skipNav = document.getElementById('skipNav');
						if(skipNav != null) {
							skipNav.setAttribute("onclick" , "document.getElementById('menuContent').setAttribute('tabindex' , '0'); document.getElementById('menuContent').focus();");
						}
					}
					var skipToMenu = document.getElementById('skipToMenu');
					if(skipToMenu != null) {
						skipToMenu.setAttribute("onclick" , "document.getElementById('menuContent').setAttribute('tabindex' , '0'); document.getElementById('menuContent').focus();");
					}
					var target2 = document.getElementById('mainContent');
					if(target2 != null) {
						target2.href="#mainContent";
						target2.innerText="Main Content";
						var skipMail = document.getElementById('skipMailboxList');
						if(skipMail != null) {
							skipMail.setAttribute("onclick" , "document.getElementById('mainContent').setAttribute('tabindex' , '0'); document.getElementById('mainContent').focus();");
						}
						var skipAdminMenu = document.getElementById('skipAdminMenu');
						if(skipAdminMenu != null) {
							skipAdminMenu.setAttribute("onclick" , "document.getElementById('mainContent').setAttribute('tabindex' , '0'); document.getElementById('mainContent').focus();");
						}
					}
					var target3 = document.getElementById('mailboxListContent');
					if(target3 != null) {
						target3.href="#mailboxListContent";
						target3.innerText="Mailbox List";
						var skipMenu = document.getElementById('skipMenu');
						if(skipMenu != null) {
							skipMenu.setAttribute("onclick" , "document.getElementById('mailboxListContent').setAttribute('tabindex' , '0'); document.getElementById('mailboxListContent').focus();");
						}
					}
				}
				$('.hidden_context').focus(function(e) {
					$(e.target).addClass('visible');
					if($(e.target).parent().hasClass('customMailboxAccessibleMenu')) {
						$(e.target).parent().css('height','15px');
					}
				});
				$('.hidden_context').blur(function(e) {
					$(e.target).removeClass('visible');
					if($(e.target).parent().hasClass('customMailboxAccessibleMenu')) {
						$(e.target).parent().css('height','0px');
					}
				});
				
				delay(function() {
					$('#tinyeditorframe').contents().find('html').bind('keydown',function(e) {
						var code = (e.keyCode ? e.keyCode : e.which);
						if(code == 9) { //tab keycode
							e.preventDefault();
							if(e.shiftKey) {
								$('#testyle').focus();
							}
							else {
								$('#send_btn').focus();
							}
						}
					});
				},15);
				$('#message_body').bind('keydown',function(e) {
					var code = (e.keyCode ? e.keyCode : e.which);
					if(code == 9) { //tab keycode
						e.preventDefault();
						if(e.shiftKey) {
							$('#testyle').focus();
						}
						else {
							$('#send_btn').focus();
						}
					}
				});
				$('div.admin_chart').mouseover(function(e) {
					$('.hidden_chart').addClass('visible');
				});
				$('div.admin_chart').mouseout(function(e) {
					$('.hidden_chart').removeClass('visible');
				});
				if($('#last_button').val() != null) { 
					if($('#last_button').val().length) {
						$('#'+$('#last_button').val()).focus();
					}
				}
				
				//BEGIN FLAGGING LOGIC
				//event handlers for empty flag slot hovering
				$('img.no_flag').mouseover(function() {
					$(this).attr('src','/images/icons/flag_less_transparent.png');
				});
				$('img.no_flag').mouseout(function() {
					$(this).attr('src','/images/icons/flag_transparent.png');
				});
				function unbind_flag(image){
					$(image).unbind('mouseover');
					$(image).unbind('mouseout');
					$(image).removeClass('no_flag');
				}
				function bind_flag(image){
					$(image).attr('alt','No Flag');
					$(image).attr('src','/images/icons/flag_transparent.png');
					$(image).addClass('no_flag');
					$(image).mouseover(function() {
						$(this).attr('src','/images/icons/flag_less_transparent.png');
					});
					$(image).mouseout(function() {
						$(this).attr('src','/images/icons/flag_transparent.png');
					});
				}
				//event handler to add flag menu
				$('a.flag').each(function() { 
					update_qtip(this)
				});
				function update_qtip(input){
					if (!$(input).children('img').hasClass('no_flag')){
						$(input).qtip({
							content: {
								text: function(event, api) {
									var display = "";
									if($(input).children('img').attr('message') != ''){
										display += "<span style = \"font-size: 12px;\"> " + nl2br($(input).children('img').attr('message').substring(0,269), false) +(($(input).children('img').attr('message').length>270)?"...":"")+"</span><br/><br/>";
									}
									if($(input).children('img').attr('modify_user') != null){
										display += "<span style = \"color: gray; font-size: 9px;\">Created: " +$(input).children('img').attr('create_user')+ " - " + formatDate(new Date($(input).children('img').attr('create_time')* 1000)) + "  </span>";
										display += "<br/><span style = \"color: gray; font-size: 9px;\">Modified: " +$(input).children('img').attr('modify_user')+ " - " + formatDate(new Date($(input).children('img').attr('modify_time')* 1000)) + "</span>";
									}
									else{
										display += "<span style = \"color: gray; font-size: 9px;\">Loading...</span>";
									}
									return display;
								}	
							},
							style: {
								classes: 'qtip-light qtip-rounded',
							},
							show: {
							},
							hide:{
								fixed:true,
								delay:50
							},
							position: {
								my: 'left top',
								at: 'right top' 
							}
						});
					}
				}
				$('a.flag').click(function(e) {
					//define index of is not set
					defineIndexOf();
					//var db_id = ($(e.target).attr('db_id') != null) ? $(e.target).attr('db_id') : $(e.target).parent().attr('db_id');
					var img_obj = ($(e.target).children('img').attr('id') != null) ? $(e.target).children('img') : $(e.target);
					var uid = img_obj.attr('id').replace("_flagimg","");
					
					var old_color = $(img_obj).attr('color');
					if(old_color==null){
						old_color="";
					}
					e.stopImmediatePropagation();
					$(img_obj.parent()).qtip("destroy");
					$('#flag-cancel').click(); 
					$('.flag-menu').remove(); 
					var colors = new Array('red','purple','blue','green','orange','brown');
					var menu = '<div id="flag_menu" class="flag-menu">';
					for(var i = 0; i < colors.length; i++) {
						menu += '<a href="#" class="flag"><img color="'+colors[i]+'" id="modal_flagimg_'+colors[i]+'_'+uid+'" class="flag flag-selector '+((colors[i] == old_color)?'selected-flag':'')+'" src="/images/icons/flag_'+colors[i]+'.png" alt="'+colors[i]+' Flag" title="'+((colors[i] == old_color)?'Selected ':'')+colors[i].charAt(0).toUpperCase()+ colors[i].slice(1)+' Flag"/></a>';
					}
					menu +=  '<a href="#" class="flag"><img color="" id="modal_flagimg_transparent_'+uid+'" class="flag flag-selector '+(("" == old_color)?'selected-flag':'')+'" src="/images/icons/flag_transparent.png" alt="'+(("" == old_color)?'Selected ':'')+'Remove Flag" title="Remove Flag"/></a>';
					menu += '<br/>';
					menu += '<form id="flag_message_form" method="POST" action="/inbox/save_flag_message">';
					menu += '<label for="flag_message_text" class="hidden_context">Flag Message</label>';
					menu += '<textarea '+((img_obj.hasClass('no_flag'))?'disabled':"")+' id="flag_message_text" class="flag-textarea" name="flag_message_text">'+((img_obj.attr('message') != null && !img_obj.hasClass('no_flag')) ? img_obj.attr('message') : '') +'</textarea>';
					menu += '<input type="hidden" name="message_uid" value="'+img_obj.attr('id').replace('_flagimg','')+'" />';
					menu += '<input type="hidden" name="'+$('input[type="hidden"].token').attr('id')+'" value="'+$('input[type="hidden"].token').val()+'" />';
					menu += '<br/>';
					if($(img_obj).attr('modify_user') != null){
						menu += '<a href="#" class="hidden_context">Modified by '+$(img_obj).attr('modify_user')+' on '+new Date($(img_obj).attr('modify_time')*1000)+'</a>';
						menu += '<a href="#" class="hidden_context">Created by '+$(img_obj).attr('create_user')+' on '+new Date($(img_obj).attr('create_time')*1000)+'</a>';
					}
					if($(img_obj).attr('flag_id') != null){
						menu += '<input type="hidden" value="'+$(img_obj).attr('flag_id')+'" id="flag_id" name="flag_id"/>'
					}
					menu += '<input type="hidden" value="" id="color-flag" name="color-flag"/>'
					menu += '<div style= "float:right;">'
					menu += '<input class="minimal minimal-short" type="button" id="flag-save" value="Save" style="right: 10px; padding: 1px;">';
					menu += '<input class="minimal minimal-short" type="button" id="flag-cancel" value="Cancel" style=" right:5px; padding: 1px; ">';
					menu += '</div><br/><br/>';
					menu += '</form>';
					menu += '</div>';
					var pos = getPos(e.target);
					$(menu).appendTo('body').css({top: (pos[1]) + 'px', left: (pos[0] + 20) + 'px'});
					
					//handle keyboard focusing

					$('#flag_menu').children('a.flag').first().focus();
					//handle click events on colored flags in menu
					$('#flag_menu > a.flag').click(function(e) {
						var color = ($(e.target).attr('color') != null) ? $(e.target).attr('color') : $(e.target).children('img').attr('color');
						$('.selected-flag').attr('title',$('.selected-flag').attr('title').replace("Selected ",""));
						$('.selected-flag').attr('alt',$('.selected-flag').attr('alt').replace("Selected ",""));
						$('.selected-flag').removeClass('selected-flag');
						var element = null;
						if($(e.target).hasClass('flag-selector')){//change which flag is selected
							element = $(e.target);
						}else{
							element = $(e.target).children('img');
						}
						var src = element.attr('src'); 
						var id = element.attr('id'); 
						var title = element.attr('title'); 
						var parent = element.parent();
						element.remove();
						parent.append('<img title="Selected '+title+'" alt="Selected '+title+'" src="'+src+'" class="flag flag-selector selected-flag" id="'+id+'" color="'+color+'">');
						parent.children(':first').focus();
						setTimeout(function(){$('#StatusUpdater').html("Selected "+title);},10);
						
						
						//if its a valid color, change the color, otherwise assume we want to remove the flag
						if((colors.indexOf(color) > -1 ? true : false)) { 
							$(img_obj).attr('src','/images/icons/flag_'+color+'.png');
							$(img_obj).attr('color',color);
							$(img_obj).attr('alt',color+" Flag");
							unbind_flag(img_obj);
							$('#flag_message_text').attr('disabled', false);
						}
						else {
							bind_flag(img_obj);
							$(img_obj).attr('alt',"No Flag");
							$(img_obj).attr('color','');
							$('#flag_message_text').attr('disabled', true);
						}
					});
					
					
					//set up option for message 
					var currentMessage = img_obj.attr('message');
					var currentTime = img_obj.attr('modify_time');
					var options = {
						beforeSend: function(data){
							//modify created by
							img_obj.attr('message',$('#flag_message_text').val());
							img_obj.attr('modify_time',new Date().getTime()/1000);
						},
						success: function(data) {
							if(data != null && data != ""){
								var msg_obj = JSON.parse(data);
								img_obj.attr('message',msg_obj.content); 
								img_obj.attr('create_user',msg_obj.created_by);
								img_obj.attr('create_time',msg_obj.created_at);
								img_obj.attr('modify_user',msg_obj.modified_by);
								img_obj.attr('modify_time',msg_obj.modified_at);
								img_obj.attr('flag_id',msg_obj.id);
							}
						},
						error: function(xhr) {
							if(xhr.status != 0) { // don't give error message if ajax has aborted , it is still processed
								alert('Error saving flag message.'); 
							}
							img_obj.attr('message',currentMessage);
							img_obj.attr('modify_time',currentTime);
						}
						
					};
					
					$('#flag_message_form').ajaxForm(options);
					$('#flag-save').click(function(e){
						$('#color-flag').val($(".selected-flag").attr('color'));
						$('#flag_message_form').submit(); 
						$('.flag-menu').remove();
						update_qtip(img_obj.parent());
						img_obj.parent().focus();
					});
					$('#flag-cancel').click(function(e){
						$('.flag-menu').remove();
						if(old_color == '' ){
							bind_flag(img_obj);
							$(img_obj).attr('alt',"No Flag");
							$(img_obj).attr('color','');
							$(img_obj.parent()).qtip("destroy");
						}
						else{
							$(img_obj).attr('src','/images/icons/flag_'+old_color+'.png');
							$(img_obj).attr('color',old_color);
							$(img_obj).attr('alt',old_color+" Flag");
							update_qtip(img_obj.parent());
						}
						update_qtip(img_obj.parent());
						img_obj.parent().focus();
					});
				});
				
				//////////status functions (load on inbox views only)
				if($('#main_form').length) {
					$('#legend').qtip({content: { 
						title: 'Legend', 
						text: '<img src="/images/gray_man.png" alt="Unassigned" title="Unassigned" style="height:10px;"/> - Unassigned <br/>'
							+'<img src="/images/orange_man.png" style="height:10px; alt="Assigned to someone else" title="Assigned to someone else" /> - Assigned to someone else <br/>'
							+'<img src="/images/blue_man.png" style="height:10px; alt="Assigned to you" title="Assigned to you" /> - Assigned to you <br/>'
							+'<img src="/images/complete_man.png" style="height:10px; alt="Complete" title="Complete" /> - Complete<br/>'
						},
						style: {
							classes: 'qtip-tipped'
						},
						hide:{
							fixed:true,
							delay:50
						}
					});
					
					
					$('.message_status').click(function(){
						var id = $(this).attr('id');
						var status = $('#'+id).attr('status');
						var html = $('#'+id).html();
						if(status == "unassigned"){
							$('#'+id).html('<img id="'+id+'_img"  src="/images/blue_man.png" alt="Assigned to '+$('#display_name').attr('value')+'" title="Assigned to '+$('#display_name').attr('value')+'"/>');
							$('#'+id).attr({status:"assigned_me"});
							change_status(id , "assign_to_me", "Failed to assign message status" ,html, "unassigned",true);
						}
						else if(status == "assigned_me"){
							$('#'+id).html('<img src="/images/complete_man.png"  alt="Completed by '+$('#display_name').attr('value')+'" title="Completed by '+$('#display_name').attr('value')+'" />');
							$('#'+id).attr({status:"complete"});
							change_status(id , "complete_message", "Failed to complete message status" ,html, "assigned_me",true);
						}
						else if(status == "complete"){
							$('#'+id).html('<img id="'+id+'_img"  src="/images/gray_man.png" alt="Unassigned" title="Unassigned"/>');
							$('#'+id).attr({status:"unassigned"});
							change_status(id , "reset_message_status", "Failed to reset message status" ,html,"complete", true);
						}
						else{//assigned to other to do
						}
					});
					$('#assign_button').click(function(e) {
						$('#assign_menu').attr({style:""});
						$('#assign_menu').remove();
						$('.token-input-dropdown-dpii').remove();
						$('html').unbind('click');
						$.ajax({
							url : '/inbox/assign_search_menu/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
							}).done(function(data){
								$('#assign_menu').attr({style:""});
								$('#assign_menu').remove();
								$('.token-input-dropdown-dpii').remove();
								$(document.body).append(data);
								$('#assign_menu').css('top',($('#assign_button').offset().top + 31) + 'px');
								$('#assign_menu').css('left',($('#assign_button').offset().left) + 'px');
								$('html').click(function(e) { 
									if((!$('#assign_menu').find($(e.target)).length) && $(e.target).attr('id') != $('#assign_menu').attr('id')) {
										$('#assign_menu').attr({style:""});
										$('#assign_menu').remove(); 
									}
								});
							$('#assign_menu').find('input[type="text"]').focus();
						});
					});
				}
				//////////end status functions
			});
			
			function getPos(ele){
				var x = 0;
				var y = 0;
				while(true){
					x += ele.offsetLeft;
					y += ele.offsetTop;
					if(ele.offsetParent === null){
						break;
					}
					ele = ele.offsetParent;
				}
				return [x, y];
			}
			//END FLAGGING LOGIC

			function skipToAccessibleTextEditor() {
				$('#message_body').focus();
			}
			function ajaxMessageCheck(button) {
				$.ajax({
							url: '/inbox/message_waiting_count/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
							success: function(msg_count) {
								if(msg_count.indexOf('<!-- AUTH -->') >=0) {
									window.location = '/auth/logout';
								}
								else {
									if(button != null) {
										var nth = noty({
											text: 'Message list refreshed.',
											type: 'info',
											timeout: 5000,
											focusAfter:$('#get_mail_btn')
										});
									}
									if(msg_count > 0) {
										$.ajax({
											url: '/inbox?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
											success: function(data) {
												if(data.indexOf('<!-- AUTH -->') >=0) {
													window.location = '/auth/logout';
												}
												else {
													var temp = data;
													var dom = document.createElement('div');
													dom.innerHTML = temp;
													var wrapper = $("#wrapper", dom);
													$(document).attr("title", $("<div>").html(data).find('title').text());
													$('#wrapper').html(wrapper.children());
													$('body').append('<audio controls="controls" autoplay="autoplay" style="display: none;"><source src="/audio/newmail.mp3" type="audio/mpeg" /><source src="/audio/newmail.ogg" type="audio/ogg" /></audio><!--[if lt IE 9]><embed hidden="true" height="0px" width="0px"  autoplay="true" autostart="True" src="/audio/newmail.mp3" /><![endif]-->');
													displayNotification();
												}
											}
										});
									}
								}
							}
				});
			}
			function displayNotification() {
				if (window.webkitNotifications) {
					if (window.webkitNotifications.checkPermission() > 0) {
						var nth = noty({
							text: 'Desktop notifications are currently disabled, to grant permission for desktop notifications, click <a href=\"javascript:window.webkitNotifications.requestPermission(displayNotification);\">here</a>',
							type: 'alert',
							timeout: 5000
						});
					}
					else {
						var notification = window.webkitNotifications.createNotification('', 'New Message', 'New Direct Message received');
						notification.show();
						setTimeout(function(){
							notification.cancel();
						}, '15000');
					}
				}
				else {
					 if (navigator.appName == 'Microsoft Internet Explorer') {
						//figure out something to do for IE
					 }
				}				
			}
			function addAttach() {
				$('input#attach').focus(); 
			}
			function deleteAttach(id) {
				if($('.attach_input').length == 0) {
					$("<tr id=\"attach_row_new\"><td><img src=\"/images/paperclip.png\" alt=\"Attachments\" /></td><td><a href=\"javascript:addAttach();\" class=\"attach_link\">Attach a file...</a></td></tr>").insertAfter($('#attach_row'));
					$('#attach_row').remove();
					$('#attach_row_new').attr('id','attach_row');
				}
				if(id != null) { $('#' + id).remove(); }
				$('input#attach').css({'top':$('tr#attach_row').position().top, 'left':$('tr#attach_row').position().left+50});
				$('input#attach').focus(); 
			}
			
			function selectAll() {
				var select = $('#selectall');
				if(select != null) {
					var boxes = $('.selectmsg');
					for(var i = 0; i < boxes.length; i++) {
						boxes[i].checked = select.attr("checked");
						selectMsg(boxes[i]);
					}
				}
			}
			function selectMsg(box) {
				if(box.checked == true) {
					$("#archive_btn").removeAttr('disabled'); 
					$("#move_btn").removeAttr('disabled');
					$("#mark_as_read_btn").removeAttr('disabled'); 
					$("#more_button").removeAttr('disabled'); 
					$("#assign_button").removeAttr('disabled');
					$("#complete_button").removeAttr('disabled'); 
					if($('#move_btn').length) { 
						$('#move_btn').click(function(e) { moveFolderListGenerate(e) });
					}
					var boxes = $('.selectmsg');
					var count = 0;
					for(var i = 0; i < boxes.length; i++) {
						if(boxes[i].checked == true) { count++; }
					}
					if(count > 1) { $("#archive_btn").html('Archive Messages'); }
					else { $("#archive_btn").html('Archive Message'); }
				}
				else {
					var display = false;
					var boxes = $('.selectmsg');
					var count = 0;
					for(var i = 0; i < boxes.length; i++) {
						if(boxes[i].checked == true) { display = true; count++; }
					}
					if(!display) { $('#archive_btn').attr('disabled','disabled'); $('#move_btn').attr('disabled','disabled'); $('#mark_as_read_btn').attr('disabled','disabled'); $('#more_button').attr('disabled','disabled');$('#assign_button').attr('disabled','disabled'); $('#complete_button').attr('disabled','disabled'); }
					if(count > 1) { $("#archive_btn").html('Archive Messages'); }
					else { $("#archive_btn").html('Archive Message'); }
				}
			}
			
			function createFolder() {
				$(document.body).append("<div class=\"overlay\"></div>");
				$.ajax({
					url : '/inbox/create_folder_form/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
				}).done(function(data){
					$(document.body).append(data);
				
					//event listeners to keep focus on create new folder modal while tabbing through the form
					$('#folder_name').keydown(function(e) { 
						var code = (e.keyCode ? e.keyCode : e.which);
						if(code == 9) { //tab keycode
							if(e.shiftKey) {
								e.preventDefault();
								$('#create_folder_cancel').focus();
							}
						}
					});
					$('#create_folder_cancel').keydown(function(e) { 
						var code = (e.keyCode ? e.keyCode : e.which);
						if(code == 9) { //tab keycode
							if(!e.shiftKey) {
								e.preventDefault();
								$('#folder_name').focus();	
							}
						}
					});
					
					$('.modal').draggable();
					$('#folder_name').focus();
					$('#folder_name').focus();
				});
			}
			function moveFolder(link) {
				$('#main_form').append('<input type="hidden" name="move" value="' + link + '" />');
			}
			
			function loadingScreen() {
				$('.overlay').remove();
				$(document.body).append("<div class=\"overlay\"></div>");
				$('#pros_modal').css('display','block');
			}
			
			function provideFeedback() {
				$(document.body).append("<div class=\"overlay\"></div>");
				$.ajax({
					url : '/inbox/feedback_form/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
				}).done(function(data){
					$(document.body).append(data);
					$('.modal').draggable();
					
					var options = {
						beforeSubmit: function() {
							$('#feedback_form').css('display','none');
							$('#feedback_form').css('visibility','hidden');
							$('#feedback').append("<div id=\"processing\" style=\"height: 100px; width: 500px\"><p style=\"text-align: center; \">Processing Feedback...</p><img src=\"/images/ajax-loader-large.gif\" alt=\"Processing...\" style=\"display: block; margin-top: 10px; margin-right: auto; margin-left: auto;\" /></div>");
						},
						success: function() { 
							$('.modal').remove(); 
							$('.overlay').remove();
							var nth = noty({
								text: 'Feedback saved, thank you for your input!',
								type: 'success',
								timeout: 5000
							});
						},
						error: function(request, status, error) {
							$('#processing').remove();
							$('#feedback_form').css('display','inline');
							$('#feedback_form').css('visibility','visible');
							if(error == "Bad Request"){
								$("#feedback_error").html("The character limit for feedback is 4000.  Please reduce the size of your message to</br>4000 characters or less.");
							}
							else{
								var nth = noty({
									text: 'Failed to save feedback. If the problem persists, please contact an administrator directly.',
									type: 'error',
									timeout: 5000
								});
							}
						}
					}; 
					$('#feedback_form').ajaxForm(options);
					$('#general_feedback,#report_issue').keydown(function(e) { 
						var code = (e.keyCode ? e.keyCode : e.which);
						if(code == 9) { //tab keycode
							if(e.shiftKey) {
								e.preventDefault();
								$('#feedback_cancel').focus();
							}
						}
					});
					$('#feedback_cancel').keydown(function(e) { 
						var code = (e.keyCode ? e.keyCode : e.which);
						if(code == 9) { //tab keycode
							if(!e.shiftKey) {
								e.preventDefault();
								$('#general_feedback').focus();	
							}
						}
					});
					$('#general_feedback').focus();
				});
			}
			
			function exportCSV(log) {
				$('.overlay').remove(); //get rid of stuff if it was already there
				$('.modal').remove();
				$(document.body).append("<div class=\"overlay\"></div>");
				$.ajax({
					url : '/adminpanel/export_form/'+log+'/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
				}).done(function(data){
					$(document.body).append(data);
					$( "input.date" ).datepicker({maxDate : 0});
					$( 'input[name="start_date"]').focus();
					$('.modal').draggable();
				});
			}
			function checkdate(){
				var today = new Date().getTime();
				var retVal = true;
				if(new Date($('input[name="start_date"]').val()).getTime() > today){
					var msg = "Invalid date range, start date cannot be in the future.";
					var retVal = false;
				}
				if(new Date($('input[name="end_date"]').val()).getTime() > today){
					var msg = "Invalid date range, end date cannot be in the future.";
					var retVal = false;
				}
				if(new Date($('input[name="end_date"]').val()).getTime() < new Date($('input[name="start_date"]').val())){
					var msg = "Invalid date range, start date must be before end date.";
					var retVal = false;
				}
				if(retVal == false) { 
					$('a.error_block').remove();
					$('<a class="error_block" style="text-decoration: none;" href="#">' + msg + '</a>').insertBefore($('#export').children('p'));
					$('a.error_block').focus();
				}
				return retVal;
			}
			function addCC() {
				if($('textarea[name="message_cc"]').length) {
					$('textarea[name="message_cc"]').parent().parent().css('display','table-row');
                    $('textarea[name="message_cc"]').focus();
					$('#CC_link').remove();
				}
				$('input#attach').css({'top':$('tr#attach_row').position().top, 'left':$('tr#attach_row').position().left+50});
			}
			function useAddressList() {
				var to = $('#modal_message_to').tokenInput('get');
				var cc = $('#modal_message_cc').tokenInput('get');
				$.each(to, function(index,value) {
					$('#message_to').tokenInput('add',value);
				});
				$('textarea[name="message_to"]').focus();
				if(cc.length) {
					$.each(cc, function(index,value) {
						$('#message_cc').tokenInput('add',value);
					});
					$('textarea[name="message_cc"]').parent().parent().css('display','table-row');
                    $('#CC_link').remove();
					$('textarea[name="message_cc"]').focus();
				}
				parent.jQuery.fancybox.close();				
			}
				
			function cancelAddressList() {
				parent.jQuery.fancybox.close();
			}
			function changeGroup(group) {
				window.location = '/inbox/change_mailbox_group/' + encodeURI(group);
			}
			function addUserToGroup(group,active) { 
				$(document.body).append("<div class=\"overlay\"></div>");
				
				$.getJSON('/adminpanel/ajax_group_member_search/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val() , function(data) {
					var items = [];
					$.each(data, function(key, val) {
						items.push('<option value="'+val.uid+'">' + val.displayname + ' ('+ val.uid + ')</option>');
					});
					var users = items.join('\n');
					$('.modal').remove();
					$.ajax({
						url : '/adminpanel/add_user_to_group_form/' + group + '/' + active + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
					}).done(function(data){
						$(document.body).append(data);
						$('#users').html(users);
						$('#user_group_search').focus();
						$('input[name="user_group_search"]').keyup(function(e){
							delay(function() {
								var search = $('input[name="user_group_search"]').val();
								search = $.trim(search);
								$.getJSON('/adminpanel/ajax_group_member_search/' + rawurlencode(search) + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), function(data) {
									var items = [];
									$.each(data, function(key, val) {
										items.push('<option value="'+val.uid+'">' + val.displayname + ' ('+ val.uid + ')</option>');
									});	
									$('#users').html(items.join('\n'));
								});
							},1000);
						});
						//event handlers
						var delay = (function(){
							var timer = 0;
							return function(callback, ms){
								clearTimeout (timer);
								timer = setTimeout(callback, ms);
							};
						})();
						$('.modal').draggable();
					});
					
					$('input[name="user_group_search"]').keydown(function(e){
						var code = (e.keyCode ? e.keyCode : e.which);
						if(code == 13) { //Enter keycode
							e.preventDefault();
							return false;
						}
					});
					//event handlers
					var delay = (function(){
						var timer = 0;
						return function(callback, ms){
							clearTimeout (timer);
							timer = setTimeout(callback, ms);
						};
					})();
					$('.modal').draggable();
				});
			}
			//toggles checkbox
			function toggleSelectAll(checkbox) {
				var checkboxes = jQuery(':input:checkbox');
				if(checkbox == null || checkbox.id != 'select_all') {
					var allChecked = true;
					for(var i = 0; i < checkboxes.length; i++) {
						if(!checkboxes[i].checked && checkboxes[i].id != 'select_all') {
							allChecked = false;
						}
					}
					if(allChecked) {
						$("#select_all").attr('checked', true);
					}
					else {
						$("#select_all").attr('checked', false);
					}
				}
				else if(checkbox.id == 'select_all') {
					if(checkbox.checked) {
						for(var i = 0; i < checkboxes.length; i++) {
							checkboxes[i].checked = true;
						}
					}
					else {
						for(var i = 0; i < checkboxes.length; i++) {
							checkboxes[i].checked = false;
						}
					}
				}
			}
			function populateUserToGroupSelection() {
				//event handlers
				var delay = (function(){
					var timer = 0;
					return function(callback, ms){
						clearTimeout (timer);
						timer = setTimeout(callback, ms);
					};
				})();
				delay(function() {
					var search = $('input[name="user_group_search"]').val();
					search = $.trim(search);
					$.getJSON('/adminpanel/ajax_group_member_search/' + rawurlencode(search) + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), function(data) {
						var items = [];
						$.each(data, function(key, val) {
							items.push('<option value="'+val.uid+'">' + val.displayname + ' ('+ val.uid + ')</option>');
						});	
						$('#users').html(items.join('\n'));
					});
				},1000);
			}
			function updateTimezoneList(country) {
				$.getJSON('/settings/ajax_timezone_list/' + rawurlencode(country.value) + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), function(data) {
					var items = [];
						$.each(data, function(key, val) {
							if(val.selected == true) { items.push('<option value="' + val.value + '" selected>' + val.text + '</option>'); }
							else { items.push('<option value="' + val.value + '">' + val.text + '</option>'); }
						});	
						$('select[name="timezone"]').html(items.join('\n'));
				});
			}
			
			function mainFormValidationOnSubmit() {
				if(navigator.appName == 'Microsoft Internet Explorer') {
					if($('#pros_modal').length) {
						$('#pros_modal').html("<p style=\"text-align: center; \">Processing Request...</p><img src=\"/images/ajax-loader-large.gif\" alt=\"Processing...\" style=\"display: block; margin-top: 10px; margin-right: auto; margin-left: auto;\" />"); 
					}
				}
				clearInterval(draft_interval);
				if($("#compose_form").length) {
					if($('button#search_btn').attr('clicked') != "true") {
						if($('#message_body').css('display') == 'none') {
							$('textarea[name="message_body"]').val(editor.getEditorContent()); //need to set textarea content on submit
						}
						if($('textarea[name="message_to"]').val().length == 0 && $('#save_btn').attr('clicked') != 'true') { 
								$("#pros_modal").css('display','none');
								$('.overlay').remove(); 
								alert('At least one recipient must be specified.'); 
								$('#save_btn').removeAttr('clicked');
								$('#send_btn').removeAttr('clicked');
								return false; 
						}
						else if($('p.untrusted').length && $('#save_btn').attr('clicked') != 'true') {
							$("#pros_modal").css('display','none');
							$('.overlay').remove(); 
							$('#untrusted-dialog').remove(); 
							var addresses = '';
							var to_remove = [];
							var i = 1;
							var j = 0;
							$('p.untrusted').each(function() {
								addresses += $(this).attr('data-address');
								to_remove[j] = $(this).attr('data-address');
								if(i < $('p.untrusted').length && $('p.untrusted').length > 1) { addresses += ', '; }
								i++;
								j++;
							});
							$('<div id=\"untrusted-dialog\" title="Untrusted Recipients">'+ 
								'<a class="hidden_context" href="#">Untrusted Recipients</a>'+
								'<p>The following recipients are untrusted: '+addresses+
								'.</p><p>Untrusted recipients must be removed before sending.</p><p>Click "Remove All" to remove all untrusted recipients,'+
								' or "Cancel" to cancel send and review recipients individually.</p>'+
							   '</div>').dialog({
									buttons: [
										{ text: 'Remove All', click : function() { 
											var i = 0;
											$(to_remove).each(function() {
												$("#message_to").tokenInput('remove', { id : to_remove[i] });
												$("#message_cc").tokenInput('remove', { id : to_remove[i] });
												i++;
											});
											$(this).dialog('close'); } 
										},
										{ text: 'Cancel', click : function() { $(this).dialog('close'); } }
									],
									close: function() { $('#menuContent').focus(); }
							   }); 
							$('#save_btn').removeAttr('clicked');
							$('#send_btn').removeAttr('clicked');
							return false;
						}
						else if($('p.unvalidated').length && $('#save_btn').attr('clicked') != 'true') {
							$("#pros_modal").css('display','none');
							$('.overlay').remove(); 
							var addresses = '';
							var i = 1;
							$('p.unvalidated').each(function() {
								addresses += $(this).attr('title');
								if(i < $('p.unvalidated').length && $('p.unvalidated').length > 1) { addresses += ', '; }
								i++;
							});
							if(confirm('The following recipients have not been validated for trust: '+addresses+'. Message will fail to send if any of the unvalidated recipients are not trusted. Attempt to send anyway?')) {
								//do the check for missing subject too if we are planning on sending it anyway
								if($('input[name="message_subject"]').val().length == 0 && $('#save_btn').attr('clicked') != 'true') {
									if(confirm('No subject specified, send anyway?')){
										$("#pros_modal").css('display','inline');
										$(document.body).append("<div class=\"overlay\"></div>");
										return true;
									}
									else{
										$('#send_btn').removeAttr('clicked');
										return false;
									}
								}
								else {
									$("#pros_modal").css('display','inline');
									$(document.body).append("<div class=\"overlay\"></div>");
									return true;
								}
							}
							else {
								$('#send_btn').removeAttr('clicked');
								return false;
							}
						}
						else if($('input[name="message_subject"]').val().length == 0 && $('#save_btn').attr('clicked') != 'true') { 
								$("#pros_modal").css('display','none');
								$('.overlay').remove(); 
								$('#save_btn').removeAttr('clicked');
								if(confirm('No subject specified, send anyway?')){
									$("#pros_modal").css('display','inline');
									$(document.body).append("<div class=\"overlay\"></div>");
									return true;
								}
								else{
									$('#send_btn').removeAttr('clicked');
									return false;
								}
						}
						else if(parseInt($('#attachment_size').val()) > 0) {
							if(parseInt($('#attachment_size').val()) > (10*1048576)) {
								$("#pros_modal").css('display','none');
								$('.overlay').remove();
								alert('Total attachment size exceeds the 10 MB limit. Please remove attachments before trying again.');
								$('#save_btn').removeAttr('clicked');
								$('#send_btn').removeAttr('clicked');
								return false;
							}
							else { 
								return true; 
							}
						}
						else if(editor.getEditorContent().toLowerCase().indexOf('attached') >= 0 && $('#save_btn').attr('clicked') != 'true') { 
							if($('tr.attach_input').length) { 
								if($('tr#attach0').html().length <= 0) { 
									$("#pros_modal").css('display','none');
									$('#save_btn').removeAttr('clicked');
									if(confirm('Did you mean to attach files?\n\n You wrote "attached" in your message but have not attached any files, send anyway?')){
										$("#pros_modal").css('display','inline');
										$(document.body).append("<div class=\"overlay\"></div>");
										return true;
									}	
									else{
										$('#send_btn').removeAttr('clicked');
										return false;
									} 
								} 
							} 
							else { 
								$("#pros_modal").css('display','none');
								$('.overlay').remove();
								$('#save_btn').removeAttr('clicked');
								if(confirm('Did you mean to attach files?\n\n You wrote "attached" in your message but have not attached any files, send anyway?')){
									$("#pros_modal").css('display','inline');
									$(document.body).append("<div class=\"overlay\"></div>");
									return true;
								}
								else{
									return false;
								}
							}
						}
						else { $('#save_btn').removeAttr('clicked'); return true; }
					}
					else { $('button#search').removeAttr('clicked'); return true; }
				}
				else { return true; }
			}
			
			function moveFolderListGenerate(e) {
				$('.menu_modal').remove();
				$(document.body).append(
						"<div id=\"move_menu\" style=\" top:" + ($('#' + e.target.id).offset().top + 31) + "px; " + "left: " + $('#' + e.target.id).offset().left + "px;" + "\" class=\"menu_modal\">" +
							"<p>Move To:</p>" + 
							"<img src=\"/images/ajax-loader.gif\" alt=\"Loading...\"/>" +
						"</div>"
				);
				$.getJSON('/inbox/json_folder_list/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), function(data) {
					var items = [];
					$.each(data, function(key, val) {
						items.push('<li><a onclick=\"moveFolder(\'' + val.link + '\'); $(\'#main_form\').submit();\">' + val.label + '</a></li>');
					});
					$('#move_menu').html(
							"<p>Move To:</p>" + 
							"<ul>" + 
								items.join('\n') +
							"</ul>"
					);
					$('#move_menu > ul > li > a').focus();
				});
				
				$('html').click(function(e) { $('.menu_modal').remove(); });
				$('#move_menu').blur(function(e) { $('#move_menu').remove(); });
				e.stopPropagation();
			}
			
			function autoSaveDraft() {
				$("#main_form").trigger('autosave');			
			}
			
			function addressList() {
				$.fancybox.showActivity();
				$.ajax({
					url : '/addressbook/address_list/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
				}).done(function(data){
					if(data.indexOf('<!-- AUTH -->') >=0) {
						window.location = '/auth/logout';
					}
					else {
						$.fancybox({
							'content' : data,
							'autoDimensions' : false,
							'padding' : 0,
							'height' : 500,
							'width' : 750,
							'onComplete' : function() { $('#address_search_input').focus(); $('#address_search_input').focus();}
						});
						$('#fancybox-wrap').css("top","0px");
						$('#fancybox-outer').css({ "border" : "solid #efefef 10px", "border-radius" : "10px"});
						$('#fancybox-close').css({"top": "-25px", "right" : "-25px"});
						jQuery("textarea[class*=expand]").TextAreaExpander(19);

						$("#address_book_wrapper").parent().scroll(function(){			
							$("#result_panel")
								.stop()
								.animate({"marginTop": ($("#address_book_wrapper").parent().scrollTop()) + "px"}, 400);			
						});
					}
				});
			}
			
			function contactsList() {
				$.fancybox.showActivity();
				$.ajax({
					url : '/addressbook/contacts_list/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
				}).done(function(data){
					if(data.indexOf('<!-- AUTH -->') >=0) {
						window.location = '/auth/logout';
					}
					else {
						$.fancybox({
							'content' : data,
							'padding' : 0,
							'autoDimensions' : false,
							'height' : 500,
							'width' : 750,
							'onComplete' : function() { $('#add_contact_link').focus(); }
						});
						$('#fancybox-wrap').css("top","0px");
						$('#fancybox-outer').css({ "border" : "solid #efefef 10px", "border-radius" : "10px"});
						$('#fancybox-close').css({"top": "-25px", "right" : "-25px"});
						jQuery("textarea[class*=expand]").TextAreaExpander(19);

						$("#address_book_wrapper").parent().scroll(function(){			
							$("#result_panel")
								.stop()
								.animate({"marginTop": ($("#address_book_wrapper").parent().scrollTop()) + "px"}, 400);			
						});
					}
				});	
			}
			
			function multipleAddressSplit(address){	
				var add = address.id.replace(new RegExp("(&quot;|\")(.*?)(&quot;|\")","g"),"");
				add = add.replace(new RegExp("(&lt;|<)","g"),"");
				add = add.replace(new RegExp("(&gt;|>)","g"),"");
				var array = add.split(/[;,]+/);
				if(array.length > 1){
					$.each(array, function(key, val){
							if(val.length > 1) {
								$('#'+address.uid).parent().parent().parent().children('textarea').tokenInput('add',{ name : val, id : val, uid: uniqid() });
							}
					});
					$('#'+address.uid).parent().parent().parent().children('textarea').tokenInput('remove', address );
					return true;
				}
				else{
					return false;
				}
				
			}
			
			function useAddressList() {
				var to = $('#modal_message_to').tokenInput('get');
				var cc = $('#modal_message_cc').tokenInput('get');
				$.each(to, function(index,value) {
					$('#message_to').tokenInput('add',value);
				});
				$('textarea[name="message_to"]').focus();
				if(cc.length) {
					$.each(cc, function(index,value) {
						$('#message_cc').tokenInput('add',value);
					});
					$('textarea[name="message_cc"]').parent().parent().css('display','table-row');
                    $('#CC_link').remove();
					$('textarea[name="message_cc"]').focus();
				}
				parent.jQuery.fancybox.close();				
			}
				
			function cancelAddressList() {
				parent.jQuery.fancybox.close();
			}
			
			function verifyAddress(address) {
				var address_str = address.id;
				$.ajax({
					url : '/inbox/valid_trusted_address/' + rawurlencode(base64_encode(address_str)) + '/?' + $('input[type="hidden"].token').attr('id') + '=' + $('input[type="hidden"].token').val()
				}).done(function(data) {
					var response = jQuery.parseJSON(data);
					if(response != null && typeof response =='object') {
						if(response.valid) {		
							var trusted = $("<span class=\"token-input-hidden_context\">(Trusted Address)</span>");
							$("#"+address.uid).append(trusted);
							$("#"+address.uid).attr('title',$("#"+address.uid).attr('title') + ' (Trusted)');
							$("#"+address.uid).removeClass('unvalidated');
							$("#"+address.uid).addClass('trusted');
							$("#"+address.uid).parent().removeClass('unvalidated');
							$("#"+address.uid).parent().addClass('trusted');
						}
						else {
							var untrusted = $("<span class=\"token-input-hidden_context\">(Untrusted Address)</span>");
							$("#"+address.uid).append(untrusted);
							$("#"+address.uid).attr('title',$("#"+address.uid).attr('title') + ' (Untrusted)');
							$("#"+address.uid).removeClass('unvalidated');
							$("#"+address.uid).addClass('untrusted');
							$("#"+address.uid).parent().removeClass('unvalidated');
							$("#"+address.uid).parent().addClass('untrusted');
							$("#"+address.uid).attr('data-message',response.message);
						}
					}
					else {
						alert('Problem validating address: ' + address_str + ' as trusted.');
					}
				});
			}
			
			function defineIndexOf(){
				if (!Array.prototype.indexOf)
				{
				  Array.prototype.indexOf = function(elt /*, from*/)
				  {
					var len = this.length >>> 0;

					var from = Number(arguments[1]) || 0;
					from = (from < 0)
						 ? Math.ceil(from)
						 : Math.floor(from);
					if (from < 0)
					  from += len;

					for (; from < len; from++)
					{
					  if (from in this &&
						  this[from] === elt)
						return from;
					}
					return -1;
				  };
				}
			}
			
			function formatDate(time) {
				var hour = time.getHours();
				var month = time.getMonth() + 1;
				var day = time.getDate();
				var minute = time.getMinutes();
				if(hour == 12) { var ampm = "pm"; }
				else if(hour > 12){
					hour = hour - 12;
					var ampm = "pm";
				}
				else if(hour == 0){
					hour = 12;
					var ampm = "am";
				}
				else {
					var ampm = "am";
				}
				if(hour < 10) { hour = "0" + hour; }
				if(minute < 10) { minute="0" + minute; }
				if(month < 10) { month = "0" + month; }
				if(day < 10) { day = "0" + day; }
				return ""+month+"/"+day+"/"+time.getFullYear()+" "+hour+":"+minute + ampm;
			}
			
			//////////status functions
			function assign_to_other(id,user_id,name){ //assign message status manually
					var old_status = $('#'+id).attr('status');
					var old_html = $('#'+id).html();
					if(user_id != $('#current_user').attr('value')){
						$('#'+id).html('<img id="'+id+'_img"  src="/images/orange_man.png" alt="Assigned to '+name+'" title="Assigned to '+name+'"/>');
						$('#'+id).attr({status:"assigned_other"});
					}
					else{
						$('#'+id).html('<img id="'+id+'_img"  src="/images/blue_man.png" alt="Assigned to '+name+'" title="Assigned to '+name+'"/>');
						$('#'+id).attr({status:"assigned_me"});
					}
					$.ajax({
						url : '/inbox/assign_message_status/'+ id + '/'+user_id+'/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
						success: function(data) {
							var data = $.parseJSON(data);	
							if(!data.success){
								$('#'+id).html(old_html);
								$('#'+id).attr({status:old_status});
							}
						},	
						error: function(xhr){
							if(xhr.status != 0){
								$('#'+id).html(old_html);
								$('#'+id).attr({status:old_status});
							}
						}
					});
				}
				function assign_selected(user_id,name){//assign selected messages
					
					if($('.detailed_status').length == 0){
						$('.selectmsg:checked').each(function(){
							var id = $(this).attr('id');
							var message_id = 'status_'+id.substring(id.indexOf('t')+1);
							assign_to_other(message_id,user_id,name);					
						});
					}
					else{
						assign_to_other($('.message_status').attr('id'),user_id,name);
					}
				}
				function complete_selected(){//complete selected messages
					var ato=false;
					$('.selectmsg:checked').each(function(){
						var id = $(this).attr('id');
						var status_id = 'status_'+id.substring(id.indexOf('t')+1);
						var old_status = $('#'+status_id).attr('status');
						var old_html = $('#'+status_id).html();
						if(old_status == "unassigned" || old_status == "assigned_me"){
							$('#'+status_id).html('<img id="'+status_id+'_img"  src="/images/complete_man.png" alt="Completed by '+$('#display_name').attr('value')+'" title="Completed by '+$('#display_name').attr('value')+'"/>');
							$('#'+status_id).attr({status:"complete"});
							change_status(status_id , "complete_message", "Failed to assign message status" ,old_html, old_status,false);
						}
						else if(old_status == "complete"){
							//do nothing
						}
						else{//belongs to other
							ato = true;
						}
						
					});
					if(ato){
						alert("Some messages are assigned to other people.  You must assign it to yourself before completing the task.");
					}
				}
				function complete_current(){
					var id = $('.message_status').attr('id')
					var old_status = $('#'+id).attr('status');
					var old_html = $('#'+id).html();
					if(old_status != "complete"){
						if(old_status == "assigned_other" || old_status == "complete_other"){
							alert("Message assigned to a different user.  Status was not changed.");
						}
						else{
							$('#'+id).html('<img id="'+id+'_img"  src="/images/complete_man.png" alt="Completed by '+$('#display_name').attr('value')+'" title="Completed by '+$('#display_name').attr('value')+'"/>');
							$('#'+id).attr({status:"complete"});
							change_status(id , "complete_message", "Failed to assign message status" ,old_html, old_status,true);
						}
					}
				}
				function change_status(id, callurl, errormessage ,reverthtml,revertstatus, alerts){//change status helper
					var db_id = $('#'+id).attr('db_id');
					if(db_id != ''){
						db_id = '/' + db_id;
					}
					$.ajax({
						url : '/inbox/'+callurl+'/'+ id + db_id+'/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
						success: function(data) {
							var data = $.parseJSON(data);	
							if(!data.success){
								if(data.error="already assigned"){
									if(data.complete == 1){
										$('#'+id).html('<img id="'+id+'_img"  src="/images/complete_man.png" alt="Completed by '+data.assigned_to+'" title="Completed by '+data.assigned_to+'"/>');
										$('#'+id).attr({status:"completed_other"});
									}
									else{
										$('#'+id).html('<img id="'+id+'_img"  src="/images/orange_man.png" alt="Assigned to '+data.assigned_to+'" title="Assigned to '+data.assigned_to+'"/>');
										$('#'+id).attr({status:"assigned_other"});
									}
									$('#'+id).attr({db_id:data.id});
									if(alerts){
										alert("Message assigned to " +data.assigned_to);
									}
								}
								else{
									if(alerts && data.error != null){
										alert(errormessage);
									}
								}
							}
							else{
								$('#'+id).attr({db_id:data.id});
							}
						},	
						error: function(xhr ){
							if(xhr.status != 0){
								$('#'+id).html(reverthtml);
								$('#'+id).attr({status:revertstatus});
								if(alerts){
									alert(errormessage);
								}
							}
						}
					});
				}
				
				///////end status functions
			
			//////////dist list expand functions
			function expandAddresses(token, display_names, addresses_in_display_order, field_name) {
				var name_array = display_names.split(';');
				var address_array = addresses_in_display_order.split(';');
				for(var i = 0; i < name_array.length; i++) {
					$('textarea[name="' + field_name + '"]').tokenInput('add',{ name : htmlentities(name_array[i],'ENT_NOQUOTES'), id : address_array[i], uid: uniqid() });
				}
				$('textarea[name="' + field_name + '"]').tokenInput('remove', {id: token});
				closeDistListWindow();
			}
			
			function closeDistListWindow() {
				$('.overlay').remove(); 
				$('.modal').remove();
			}
			
			function viewDistList(token_uid, item, field_name) {
				$('.overlay').remove(); 
				$('.modal').remove();
				var item = JSON.parse(base64_decode(html_entity_decode(item)));
				var token = item.id;
				var dist_list_name = item.name;
				var display_names = item.display_names;
				var addresses_in_display_order = item.addresses_in_display_order;
				var address_tokens = JSON.parse(html_entity_decode(item.address_tokens));
				var address_token_str = '';
				for(var i = 0; i < address_tokens.length; i++) {
					if($("#"+token_uid).attr('data-message') != null && $("#"+token_uid).attr('data-message').length) {
						if($("#"+token_uid).attr('data-message').indexOf(address_tokens[i].split(" ")[0]) != -1) {
							address_token_str += '<span class="hidden_context">Untrusted address</span><span title="Untrusted" style="color: #d00;">' + address_tokens[i] + '</span><br />';
						}
						else {
							address_token_str += '<span class="hidden_context">Trusted address</span><span title="Trusted" style="color: green;">' +address_tokens[i] + '</span><br />';
						}
					}
					else {
						address_token_str += '<span class="hidden_context">Unvalidated address</span>' + address_tokens[i] + "<br />";
					}
				}
				$(document.body).append("<div class=\"overlay\"></div>");
				$(document.body).append(
					"<div id=\"dist_list_expand\" class=\"modal\" style=\"width:600px;\">"
					+ '<a href="#" id="dist_list" class="hidden_context">Distribution list members modal panel</a>'
					+ "<h1>" + dist_list_name + "</h1>"
					+ "<form action=\"/inbox/form_check\" id=\"dist_list_expand_form\" method=\"POST\">"
					+ "<p>All recipients in the distribution list are listed below</p>"
					+ "<label for=\"recepients_in_dist_list\" class=\"hidden_context\">Recipients in the Distribution List</label>"
					+ "<div>" + address_token_str + "</div><br/>"
					+ "<button class=\"minimal\" style=\"padding-left: 5px; padding-right: 5px;\" type=\"button\" name=\"dist_list_expand\" id=\"submit_dist_list_expand\" onclick=\"expandAddresses('"+ token + "','" + display_names + "','" + addresses_in_display_order + "','" + field_name + "');\">Expand</button>&nbsp;&nbsp;"
					+ "<button class=\"minimal\" style=\"padding-left: 5px; padding-right: 5px;\" type=\"button\" name=\"dist_list_expand_cancel\" id=\"dist_list_expand_cancel\" onclick=\"closeDistListWindow();\">Cancel</button>&nbsp;"
					+ "</form>"
					+ "</div>");
				$('#dist_list').focus();
				$('.modal').draggable();
				
			}

			//////////end dist list expand functions
			
			function getPersonalAddressBook() {
				$.fancybox.showActivity();
						$.ajax({
							url : '/addressbook/mainContacts/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
						}).done(function(data){
							if(data.indexOf('<!-- AUTH -->') >=0) {
								window.location = '/auth/logout';
							}
							else {
								$.fancybox({
									'content' : data,
									'padding' : 0,
									'autoDimensions' : false,
									'height' : 520,
									'width' : 750,
									'titlePosition' : 'inside',
									'onComplete' : function() { 
										$('#add_contact_link').focus();
										$('#add_contact_link').focus();
										
									}
								});
								$('#fancybox-wrap').css("top","0px");
								$('#fancybox-outer').css({ "border" : "solid #efefef 10px", "border-radius" : "10px"});
								$('#fancybox-close').css({"top": "-25px", "right" : "-25px"});
	
								$("#address_book_wrapper").parent().scroll(function(){			
									$("#result_panel")
										.stop()
										.animate({"marginTop": ($("#address_book_wrapper").parent().scrollTop()) + "px"}, 400);			
								});
							}
						});
			}
			function getGlobalAddressBook() {
				$.fancybox.showActivity();
						$.ajax({
							url : '/addressbook/mainindex/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
						}).done(function(data){
							if(data.indexOf('<!-- AUTH -->') >=0) {
								window.location = '/auth/logout';
							}
							else {
								$.fancybox({
									'content' : data,
									'autoDimensions' : false,
									'padding' : 0,
									'height' : 520,
									'width' : 750,
									'titlePosition' : 'inside',
									'titleFormat' : function() { 
										return ''; 
									},
									'onComplete' : function() { 
										$('#address_search_input').focus();
									}
								});
								
								$('#fancybox-wrap').css("top","0px");
								$('#fancybox-outer').css({ "border" : "solid #efefef 10px", "border-radius" : "10px"});
								$('#fancybox-close').css({"top": "-25px", "right" : "-25px"});
								
								$("#address_book_wrapper").parent().scroll(function(){			
									$("#result_panel")
										.stop()
										.animate({"marginTop": ($("#address_book_wrapper").parent().scrollTop()) + "px"}, 400);			
								});
							}
						});
				}
					
			function getWebservicePermission(mailbox_name, is_group) {
				$.fancybox.showActivity();
				$.ajax({
					url : '/registration/get_webservice_permission/' + mailbox_name + '/' + is_group + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
				}).done(function(data){
					var data_arr = jQuery.parseJSON(data);
					var permission_url = data_arr['permission_url'];
					$('#permission_url').attr('href', permission_url);
					$('#permission_url').fancybox(
							{'type':'iframe',
							'height' : 200,
							'width' : 900,}
					);
					$('#fancybox-wrap').css("top","0px");
					$('#fancybox-outer').css({ "border" : "solid #efefef 10px", "border-radius" : "10px"});
					$('#fancybox-close').css({"top": "-25px", "right" : "-25px"});
					$('#permission_url').click();
				});
			}
			
			function checkBeforeAfterDates(start_date_id, end_date_id, message) {
				var startDate = -1;
				if($('#' + start_date_id).datepicker('getDate') != null) { 
					startDate = $('#' + start_date_id).datepicker('getDate').getTime();
				}
				var endDate = -1;
				if($('#' + end_date_id).datepicker('getDate') != null) { 
					endDate = $('#' + end_date_id).datepicker('getDate').getTime();
				}
				var dateErrorMessage = document.getElementById('date_error_message');
				var filterButton = document.getElementById('filter_button');
				if(endDate < startDate && endDate != -1) {
					if(dateErrorMessage.innerHTML.indexOf(message) < 0) {
						dateErrorMessage.innerHTML += message + '<br>';
					}
					if(dateErrorMessage.innerHTML != '') {
						$( "#date_error_message" ).fadeIn('slow');
						filterButton.disabled = true;
						filterButton.className = 'minimal_disabled';
					}
				}	
				else {
					if(dateErrorMessage.innerHTML.indexOf(message) >= 0) {
						dateErrorMessage.innerHTML = dateErrorMessage.innerHTML.replace(message + '<br>', '');
					}
					if(dateErrorMessage.innerHTML == '') {
						$( "#date_error_message" ).fadeOut('slow');
						filterButton.disabled = false;
						filterButton.className = 'minimal';
					}
					
				}
			}
